# Contributing to Laravel's World

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to Laravel's World package, which is hosted in the [nnjeim/world](https://github.com/nnjeim/world) on GitHub. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## How Can I Contribute?

### Reporting Bugs

Explain the problem and include additional details to help maintainers reproduce the problem:

* **Use a clear and descriptive title** for the issue to identify the problem.
* **Describe the exact steps which reproduce the problem.**   
* **Provide specific examples to demonstrate the steps**.  
* **Describe the behavior you observed after following the steps** and point out what exactly is the problem with that behavior.
* **Explain which behavior you expected to see instead and why.**
* **Include screenshots.**   

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for Laravel's World, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion.  

### Pull Requests

The process described here has several goals:

- Maintain Laravel's World quality.
- Fix problems that are important to users.  

## Styleguides  

- PSR-2 Coding Standard 
